import { jsx, jsxs } from "react/jsx-runtime";
import { debugFlags, track, useEditor, useValue, Vec } from "@tldraw/editor";
import { memo, useEffect, useRef, useState } from "react";
import { useTldrawUiComponents } from "../context/components.mjs";
const DefaultDebugPanel = memo(function DefaultDebugPanel2() {
  const { DebugMenu } = useTldrawUiComponents();
  return /* @__PURE__ */ jsxs("div", { className: "tlui-debug-panel", children: [
    /* @__PURE__ */ jsx(CurrentState, {}),
    /* @__PURE__ */ jsx(FPS, {}),
    DebugMenu && /* @__PURE__ */ jsx(DebugMenu, {})
  ] });
});
function useTick(isEnabled = true) {
  const [_, setTick] = useState(0);
  const editor = useEditor();
  useEffect(() => {
    if (!isEnabled) return;
    const update = () => setTick((tick) => tick + 1);
    editor.on("tick", update);
    return () => {
      editor.off("tick", update);
    };
  }, [editor, isEnabled]);
}
const CurrentState = track(function CurrentState2() {
  useTick();
  const editor = useEditor();
  const path = editor.getPath();
  const hoverShape = editor.getHoveredShape();
  const selectedShape = editor.getOnlySelectedShape();
  const shape = path === "select.idle" || !path.includes("select.") ? hoverShape : selectedShape;
  const shapeInfo = shape && path.includes("select.") ? ` / ${shape.type || ""}${"geo" in shape.props ? " / " + shape.props.geo : ""} / [${Vec.ToInt(editor.getPointInShapeSpace(shape, editor.inputs.currentPagePoint))}]` : "";
  const ruler = path.startsWith("select.") && !path.includes(".idle") ? ` / [${Vec.ToInt(editor.inputs.originPagePoint)}] \u2192 [${Vec.ToInt(
    editor.inputs.currentPagePoint
  )}] = ${Vec.Dist(editor.inputs.originPagePoint, editor.inputs.currentPagePoint).toFixed(0)}` : "";
  return /* @__PURE__ */ jsx("div", { className: "tlui-debug-panel__current-state", children: `${path}${shapeInfo}${ruler}` });
});
function FPS() {
  const editor = useEditor();
  const showFps = useValue("show_fps", () => debugFlags.showFps.get(), [debugFlags]);
  const fpsRef = useRef(null);
  useEffect(() => {
    if (!showFps) return;
    const TICK_LENGTH = 250;
    let maxKnownFps = 0;
    let raf = -1;
    let start = performance.now();
    let currentTickLength = 0;
    let framesInCurrentTick = 0;
    let isSlow = false;
    function loop() {
      framesInCurrentTick++;
      currentTickLength = performance.now() - start;
      if (currentTickLength > TICK_LENGTH) {
        const fps = Math.round(
          framesInCurrentTick * (TICK_LENGTH / currentTickLength) * (1e3 / TICK_LENGTH)
        );
        if (fps > maxKnownFps) {
          maxKnownFps = fps;
        }
        const slowFps = maxKnownFps * 0.75;
        if (fps < slowFps && !isSlow || fps >= slowFps && isSlow) {
          isSlow = !isSlow;
        }
        fpsRef.current.innerHTML = `FPS ${fps.toString()}`;
        fpsRef.current.className = `tlui-debug-panel__fps` + (isSlow ? ` tlui-debug-panel__fps__slow` : ``);
        currentTickLength -= TICK_LENGTH;
        framesInCurrentTick = 0;
        start = performance.now();
      }
      raf = editor.timers.requestAnimationFrame(loop);
    }
    loop();
    return () => {
      cancelAnimationFrame(raf);
    };
  }, [showFps, editor]);
  if (!showFps) return null;
  return /* @__PURE__ */ jsx("div", { ref: fpsRef });
}
export {
  DefaultDebugPanel
};
//# sourceMappingURL=DefaultDebugPanel.mjs.map
